<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnUpdateV66 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('movies')) {
            Schema::table('movies', function (Blueprint $table) {
                if (!Schema::hasColumn('movies', 'ppv')) {
                    $table->boolean('ppv')->nullable();
                } else {
                    $table->boolean('ppv')->nullable()->change();
                }

                if (!Schema::hasColumn('movies', 'price')) {
                    $table->text('price')->nullable();
                } else {
                    $table->text('price')->nullable()->change();
                }

                if (!Schema::hasColumn('movies', 'offer_price')) {
                    $table->text('offer_price')->nullable();
                } else {
                    $table->text('offer_price')->nullable()->change();
                }

                if (!Schema::hasColumn('movies', 'hours')) {
                    $table->text('hours')->nullable();
                } else {
                    $table->text('hours')->nullable()->change();
                }
            });
        }

        if (Schema::hasTable('seasons')) {
            Schema::table('seasons', function (Blueprint $table) {
                if (!Schema::hasColumn('seasons', 'ppv')) {
                    $table->boolean('ppv')->nullable();
                } else {
                    $table->boolean('ppv')->nullable()->change();
                }

                if (!Schema::hasColumn('seasons', 'price')) {
                    $table->text('price')->nullable();
                } else {
                    $table->text('price')->nullable()->change();
                }

                if (!Schema::hasColumn('seasons', 'offer_price')) {
                    $table->text('offer_price')->nullable();
                } else {
                    $table->text('offer_price')->nullable()->change();
                }

                if (!Schema::hasColumn('seasons', 'hours')) {
                    $table->text('hours')->nullable();
                } else {
                    $table->text('hours')->nullable()->change();
                }

                if (!Schema::hasColumn('seasons', 'free')) {
                    $table->boolean('free')->default(0);
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        
    }
}
